﻿//
// La responsabilte de l'object DialogBox est de repecter la logique d'affaire de voxco.agent
//
//      - Retour a la page de selection de projet dans les cas ou l'erreur est irrecuperable comme par example:
//             1) Le project a ete ferme
//             2) Perte de contact avec le serveur telephonique
//             3) une erreur fatal en provenance du site de intweb
//
//  Elle utilise la classe javascript dialog qui est responsable de l'affichage son affichage a la page de intweb
//  Si cross-domain policy nous utilise fonction alert et confirm du java script
//
var DialogBox = {


    m_Document: null ,
    m_bAlertEnable: true,
    m_bShowAlertEnable: true ,
    m_DialogProperties: { alertenable: true, onClose:null, alerttitle: "warning", dialogtitle: "messsage", accept:"OK", cancel:""} ,

    getAppName: function () {
        return "Voxco.Agent";
    },

    
    enableShowAlert: function(enable) {

        if (typeof enable != "boolean")
            return;

        this.m_bShowAlertEnable = enable;
    } ,

    //
    //  Retourne a la page de selection de projet si nous detectons une erreur comme par exemple
    //      1) project en pause ou en arret
    //      2) une erreur fatale de intweb
    //      3) une erreur de communication: perte de contact avec voxcobridge ou le serveur Pronto
    //
    onClickProjectError: function () {

        try {
            var shareFrame = gClassManager.getSharedFrame();
            var closeSentinel = gClassManager.getCloseSentinelFrame();
            var agentAssignment = gClassManager.getAgentAssignmentClass();

            if (typeof agentAssignment == "object")
                agentAssignment.setLastCall(true, "onClickProjectError");


            if (typeof closeSentinel == "object")
                closeSentinel.showToolbar(true);

            if (typeof shareFrame == "object") {
                // retour a la page de selection de projet
                var appName = DialogBox.getAppName();
                shareFrame.location.href = "/" + appName + "/SelectProjects.aspx?NeedSignOff=true&CancelAutoLogin=1" + "&time=" + new Date();
            }
        }
        catch (e) {
        }
    },

    //
    // si nous detectons que nous avons une violation de la polique intra-domaine , nous reactivons les boutons essentiels pour
    // donner une porte de sortie a l'agent
    //
    onCrossDomainPolicy: function () {
        var toolbar = gClassManager.getToolbar();
        if (typeof toolbar != "object")
            return;

        toolbar.enableTbButton('btnExit', false);
        toolbar.enableTbButton('btnLastCall', false);
        toolbar.enableTbButton('btnWait', true);
        toolbar.enableTbButton('btnProjects', true);
        return;
    },

    //
    //  Affichage du dialogue pour le cross-domain-policy
    //
    CrossDomainPolicy: function (message) {
        try {
            this.showAlert(message, this.onCrossDomainPolicy);
        }
        catch (e) {
        }
        return;
    },

    //
    //  Avec les dialogue d'alertes , il faut retourner a la page des projets
    //  si et seulement si l'agent a appuye sur le bouton OK
    //
    onRemoteDisconnectClick: function () {

        try {
            //
            //  shareFrame ... frame partage entre intweb et voxco.agent
            //  closeSentinel
            //
            var shareFrame = gClassManager.getSharedFrame();
            var closeSentinel = gClassManager.getCloseSentinelFrame();
            var forceSignoff = false;

            if (typeof closeSentinel == "object") {
                closeSentinel.showToolbar(true);
                forceSignoff = closeSentinel._needSignOff;
                closeSentinel._needSignOff = false;
            }

            if (typeof shareFrame == "object") {
                var appName = DialogBox.getAppName();
                shareFrame.location.href = "/" + appName + "/SelectProjects.aspx?NeedSignOff=" + forceSignoff + "&time=" + new Date();
            }
        }
        catch (e) {
        }
    },

    init : function( properties )
    {
        if( typeof properties != "object")
            return;

        this.m_DialogProperties.onClose = this.onClose;
        if (typeof properties.onCLose == "function")
            this.m_DialogProperties.onClose = properties.onCLose;
      
        if (typeof properties.alertenable == "boolean")
            this.m_bAlertEnable = properties.alertenable;

        if (typeof properties.alerttitle == "string")
            this.m_DialogProperties.alerttitle = properties.alerttitle;

        if (typeof properties.dialogtitle == "string")
            this.m_DialogProperties.dialogtitle = properties.dialogtitle;

        if (typeof properties.cancel == "string")
            this.m_DialogProperties.cancel = properties.cancel;

        if (typeof properties.confirm == "string")
            this.m_DialogProperties.confirm = properties.confirm;

        var properties = { document: getClassManager().getDialogBoxDocument() };
        Dialog.init(properties);
        return;
    },

    onCloseDialog: function (bTimeout) {

        DialogBox.enableControl();
        if ( typeof DialogBox.m_DialogProperties.onClose != "function" )
            return;

        DialogBox.m_DialogProperties.onClose(bTimeout);
        return;
    },

    //
    //  Permet de reaction le bouton next de intweb. Durant la periode de l'affichage du dialogue , le bouton next est desactiver
    //
    enableControl: function () {
        var dialogFrameContent = getClassManager().getDialogFrameContent();
        var closesentinel = getClassManager().getCloseSentinelFrame();
        closesentinel.enableIntWebCtrl(dialogFrameContent, NextNav, true);
        return;
    },


     //  Permet de desactover le bouton next de intweb. on empeche l'agent de naviguer durant son affichage
    disableControl: function () {

        var dialogFrameContent = getClassManager().getDialogFrameContent();
        var closesentinel = getClassManager().getCloseSentinelFrame();
        closesentinel.enableIntWebCtrl(dialogFrameContent, NextNav, false);
        return;
    },

    showDialog: function (properties, message) {

        var crossdomain = getClassManager().getCrossDomainClass();
        if (typeof crossdomain == "object" && crossdomain.isCrossDomain( false ) == true) {

            //
            // Le dialogue est insere dans le document de IntWeb. Si nous ne sommes pas dans le meme domain
            // nous affichons le boite de confirmation builtin au java script
            //
            var response = confirm(message);
            if (typeof properties.onClick == "function") {
                properties.onClick(response);
                this.onCrossDomainPolicy();
            }

            return;
        }

        if (typeof properties.title != "string")
            properties.title = this.m_DialogProperties.dialogtitle;

        if (typeof properties.accept != "string")
            properties.accept = this.m_DialogProperties.accept;

        if (typeof properties.onClick != "function")
            properties.onClick = this.onClick;

        if (typeof properties.onClose != "function")
            properties.onClose = this.onCloseDialog;

        //
        //  On met inactif le bouton next du document de intweb
        //
        this.disableControl();

        var DialogPropeties = { context: getClassManager().getDialogBoxDocument(), onClose: properties.onClose , onClick: properties.onClick, timeout: properties.timeout, title: properties.title, accept: properties.accept, cancel: properties.cancel }
        Dialog.showDialog(DialogPropeties, message);
        return
    },


    showAlert: function (message, onClick ) {

        var crossdomain = getClassManager().getCrossDomainClass();
        if (typeof crossdomain == "object" && crossdomain.isCrossDomain( false ) == true) {
            alert(message);
            return;
        }
        //
        //  m_bAlertEnable : La source est le fichier de configuraltion . Nous avons la possibilite de desactive les alertes 
        //  m_bShowAlertEnable :    L'alerte est active que si l'agent est en attente d'un appel ou en entrevue. Logique 
        //                          deja existante dans le code
        //

        if (this.m_bAlertEnable == false || this.m_bShowAlertEnable == false )
            return;
       
        this.disableControl();

        var DialogPropeties = { context: getClassManager().getDialogBoxDocument(),onClose: this.onCloseDialog, onClick: onClick, title: this.m_DialogProperties.alerttitle, accept: this.m_DialogProperties.accept }
        Dialog.showAlert(DialogPropeties, message);
        return;
    },


    CloseDialog: function () {
        Dialog.closeDialog(false);
    }

};